(function() {
	CKEDITOR.plugins.add('googlethisterm', {
        lang: 'ar,en',
        icons: 'googlethisterm',
        hidpi: true,
        init: function(editor) {
        	if (editor.contextMenu) {
			    editor.addMenuGroup('googleTermGroup');
			    editor.addMenuItem('googleTermItem', {
			        label: 'Google me...',
			        onClick : function(){
			        	var sel = editor.getSelection();
			        	var url = "https://www.google.com/search?gws_rd=ssl&q="+sel.getSelectedText();
			        	window.open(url, '_blank');
			        },
			        group: 'googleTermGroup'
			    });
			    
			    editor.contextMenu.addListener( function( element ) {
			    	var sel = editor.getSelection();
			        if ( !(sel.getSelectedText()=="") ) {
			            return { googleTermItem: CKEDITOR.TRISTATE_OFF };
			        }
			    });
			}
        }
    });
})();
